module.exports = (req) =>
    new Promise((resolve, reject) => {
        const {SAMLResponse, RelayState} = req.body;

        req.api
            .authSsoCommit({SAMLResponse, RelayState})
            .then(({body}) => {
                const {status} = body;

                if (status === 'ok') {
                    resolve(body);
                }

                reject({
                    status
                });
            })
            .catch((err) => {
                return reject({
                    status: 'error',
                    error: err
                });
            });
    });
