module.exports = ({api, controller, trackId}) => {
    return api.readTrack(trackId).then(({body: {retpath = '', frontend_state = ''} = {}}) => {
        if (retpath && frontend_state === 'retpath_rewritten') {
            const redirectTo = new URL(retpath);

            redirectTo.searchParams.append('track_id', trackId);
            controller.redirect(redirectTo.toString());
        } else {
            controller.redirectToLocalUrl({
                pathname: '/auth/session',
                query: {
                    track_id: trackId
                }
            });
        }
    });
};
