const url = require('url');
const express = require('express');
const httpCodes = require('http-codes');
const router = express.Router();

const apiSetup = require('../common/apiSetup');
const langSetup = require('../common/langSetup');
const getMetrics = require('../common/getMetrics');
const getYaExperimentsFlags = require('../common/getYaExperimentsFlags');
const multiAuthAccountsSetup = require('../common/multiAuthAccountsSetup').getAccounts;
const submitData = require('../embeddedauth').submitData;
const getSession = require('../embeddedauth').getSession;
const intranetRetpathRoute = require('../auth').routes.retpath;
const rumCounterSetup = require('../common/rumCounterSetup');

const getUaTraitsData = require('./middlewares/getUaTraitsData');
const apiRequest = require('./middlewares/apiRequest');
const authSuggestGetInputLogin = require('./middlewares/authSuggestGetInputLogin');
const getStore = require('./middlewares/getStore');
const renderPage = require('./middlewares/renderPage');
const getLangList = require('./middlewares/getLangList');

const redirectStatusCode = httpCodes.MOVED_TEMPORARILY || httpCodes.FOUND;

const getRoute = [
    getYaExperimentsFlags,
    getUaTraitsData,
    getLangList,
    apiRequest('authPasswordSubmit'),
    apiRequest('validateRetpath'),
    apiRequest('validateBackpath'),
    apiRequest('authSuggest'),
    apiRequest('authPasswordGetState'),
    (req, res, next) => {
        const {authPasswordGetState: {state} = {}} = res.locals.result || {};

        if (
            typeof req.query.track_id === 'string' &&
            typeof state === 'string' &&
            !['rfc_totp', 'email_code'].includes(state)
        ) {
            return next('route');
        }
        return next();
    },
    authSuggestGetInputLogin,
    multiAuthAccountsSetup,
    langSetup,
    getStore,
    getMetrics({header: 'Новый домик'}),
    rumCounterSetup,
    renderPage
];

const postRoute = [
    function(req, _res, next) {
        if (typeof req.query.track_id === 'string') {
            return next('route');
        }
        return next();
    },
    getYaExperimentsFlags,
    getUaTraitsData,
    getLangList,
    (req, res, next) => {
        req._controller
            .getCsrfToken()
            .then((csrf) => {
                res.locals.csrf = csrf;

                next();
            })
            .catch(next);
    },
    function(req, res, next) {
        req.body.one = '1';

        if (req.query.twoweeks) {
            req.body.twoweeks = req.query.twoweeks;
        }

        return next();
    },
    submitData,
    function(req, res, next) {
        if (res.readyToGetSession) {
            return getSession(req, res, next);
        }

        return next();
    },
    function(req, res, next) {
        if (res.authFinished) {
            if (res.locals.sessguardContainer && res.locals.guardURL) {
                const answer = `<html>
                    <body>
                        <form method="post" id="form" action="${res.locals.guardURL}">
                           <input type="hidden" name="container" value="${res.locals.sessguardContainer}"/>
                        </form>
                        <script nonce="${res.locals.nonce}">
                                document.getElementById("form").submit();
                        </script>
                    </body>
                </html>`;

                return res.send(answer);
            }

            return res.redirect(
                redirectStatusCode,
                url.format({
                    protocol: req.headers['x-real-scheme'],
                    hostname: req.hostname,
                    pathname: '/auth/finish/',
                    query: {
                        track_id: res.trackId
                    }
                })
            );
        }

        if (res.state === 'rfc_totp' || res.state === 'email_code') {
            return next();
        }

        if (!res.submitErrors) {
            return res.redirect(
                redirectStatusCode,
                url.format({
                    protocol: req.headers['x-real-scheme'],
                    hostname: req.hostname,
                    pathname: '/auth/',
                    query: {
                        track_id: res.trackId
                    }
                })
            );
        }

        return next();
    },
    apiRequest('authPasswordSubmit'),
    apiRequest('validateRetpath'),
    apiRequest('validateBackpath'),
    apiRequest('authSuggest'),
    authSuggestGetInputLogin,
    multiAuthAccountsSetup,
    langSetup,
    getStore,
    rumCounterSetup,
    renderPage
];

router.use(apiSetup);
router.get('/', intranetRetpathRoute);
router.get('/', getRoute);
router.post('/', postRoute);

exports.router = router;
