const PLog = require('plog');
const processField = require('../../embeddedauth').processField;

module.exports = function apiRequest(apiMethod) {
    return function(req, res, next) {
        const data = Object.assign({}, req.query, req.body);
        const controller = req._controller;

        Object.keys(data).forEach(function(field) {
            data[field] = processField(data[field]);
        });

        const isEmptyRetpath = apiMethod === 'validateRetpath' && !data.retpath;
        const isEmptyBackpath = apiMethod === 'validateBackpath' && !data.backpath;
        const isEmptyTrackId = apiMethod === 'authPasswordGetState' && !data.track_id;

        if (isEmptyRetpath || isEmptyBackpath || isEmptyTrackId) {
            return next();
        }

        if (apiMethod === 'authSuggestForget' || apiMethod === 'authSuggestGetInputLogin') {
            data.uid = data._uid;
            delete data._uid;
        }

        if (apiMethod === 'authPasswordSubmit') {
            if (res.trackId) {
                req.api.track(res.trackId);
                data.track_id = res.trackId;
            }

            if (res.withCode) {
                data.with_code = 1;
            }

            delete data._uid;
        }

        if (!req.api[apiMethod] || typeof req.api[apiMethod] !== 'function') {
            return next();
        }

        return req.api[apiMethod](data)
            .then(function(result) {
                const body = result.body;
                const sendToLocals = {};

                sendToLocals[apiMethod] = body;

                res.locals.result = Object.assign({}, res.locals.result, sendToLocals);
                controller.augmentResponse(body);

                return next();
            })
            .catch(function(errors) {
                PLog.warn()
                    .logId(req.logID)
                    .type(`auth.new.apiRequest.${apiMethod}`)
                    .write(errors);

                if (apiMethod === 'authPasswordSubmit') {
                    return next(errors);
                }

                return next();
            });
    };
};
