const PLog = require('plog');

module.exports = function authSuggestGetInputLogin(req, res, next) {
    const resultStore = res.locals.result || {};
    const suggestedAccounts = resultStore.authSuggest && resultStore.authSuggest.accounts;
    const uid = Array.isArray(suggestedAccounts) && suggestedAccounts[0] && suggestedAccounts[0].account.uid;

    if (!uid) {
        return next();
    }

    return req.api
        .authSuggestGetInputLogin({
            uid
        })
        .then(function(result) {
            if (!res.locals.result.authSuggestGetInputLogin) {
                res.locals.result.authSuggestGetInputLogin = {};
            }

            res.locals.result.authSuggestGetInputLogin[uid] = result.body.input_login;
            return next();
        })
        .catch(function(err) {
            PLog.warn()
                .logId(req.logID)
                .type('auth.new.authSuggestGetInputLogin')
                .write(err);

            return next();
        });
};
