const apiSetup = require('../../common/apiSetup');
const multiAuthAccountsSetup = require('../../common/multiAuthAccountsSetup').getAccounts;
const apiRequest = require('./apiRequest');
const getStore = require('./getStore');
const getUaTraitsData = require('./getUaTraitsData');
const getLangList = require('./getLangList');

module.exports = [
    apiSetup,
    apiRequest('authSuggest'),
    getUaTraitsData,
    getLangList,
    multiAuthAccountsSetup,
    function(req, res, next) {
        req._controller
            .getCsrfToken()
            .then(function(token) {
                res.locals.updatedCSRF = token;

                return next();
            })
            .catch(function() {
                return next();
            });
    },
    getStore
];
