const _ = require('lodash');
const url = require('url');
const config = require('../../../configs/current/index');
const brokerPath = config.paths.broker;
const {getSocialProviders} = require('../../common/socialSetup');
const authCustomsVersion = require('../../common/getCustomConfig')('customs.version.json').version;

function getStore(req, res, next) {
    const apiRequestsResult = res.locals.result || {};
    const bbRequestsResult = res.locals.accounts;
    const tld = req._controller.getTld();
    const currentUrlObj = url.parse(url.format(req._controller.getUrl()), true);
    const needMDA = req.cookies.mda === '1';
    const queryToPass = _.pick(req.query, ['clean', 'fretpath', 'from', 'origin']);
    const embeddedAuthUrlObj = url.parse(config.paths.embeddedauth.replace('%tld%', needMDA ? 'ru' : tld), true);
    const cleanYu = res._yandexuid && res._yandexuid.replace(/[^0-9]/g, '');
    const state = apiRequestsResult.authPasswordGetState && apiRequestsResult.authPasswordGetState.state;
    const isYandex = res.locals.isYandex;

    let retpath;

    let backpath;

    if (apiRequestsResult.validateRetpath && apiRequestsResult.validateRetpath.retpath) {
        backpath = retpath = apiRequestsResult.validateRetpath.retpath;
        queryToPass.retpath = retpath;
    }

    const sessguardIsEnabled = req._controller.checkSessguard(retpath);

    const storeDraft = {
        common: {
            track_id: apiRequestsResult.authPasswordSubmit && apiRequestsResult.authPasswordSubmit.track_id,
            csrf_token: apiRequestsResult.authPasswordSubmit && apiRequestsResult.authPasswordSubmit.csrf_token,
            loginStatusRetpath: `https://${req.hostname}/auth/login-status_v2.html`,
            yu: cleanYu,
            isYandex,
            sessguardIsEnabled,
            embeddedauth_url: url.format(embeddedAuthUrlObj),
            embeddedAuthUrlObjs: embeddedAuthUrlObj,
            currentPage: req._controller.getUrl().href,
            currentUrl: url.format(currentUrlObj),
            addUserUrl: url.format(
                Object.assign({}, currentUrlObj, {
                    search: null,
                    query: Object.assign({}, currentUrlObj.query, {
                        mode: 'add-user'
                    })
                })
            ),
            editUrl: url.format(
                Object.assign({}, currentUrlObj, {
                    search: null,
                    query: Object.assign({}, currentUrlObj.query, {
                        mode: 'edit'
                    })
                })
            ),
            auth_url: url.format(
                Object.assign({}, currentUrlObj, {
                    pathname: 'auth',
                    query: queryToPass
                })
            ),
            changeDefaultUrlObj: Object.assign({}, embeddedAuthUrlObj, {
                search: null,
                query: {
                    action: 'change_default',
                    yu: cleanYu
                }
            }),
            multilogoutUrlObj: Object.assign({}, embeddedAuthUrlObj, {
                search: null,
                query: {
                    action: 'logout',
                    yu: cleanYu
                }
            }),
            profile_url: url.format(
                Object.assign({}, currentUrlObj, {
                    pathname: 'profile',
                    search: null,
                    query: queryToPass
                })
            ),
            yandex_url: `https://yandex.${tld}`,
            restoration_url: url.format(
                Object.assign({}, currentUrlObj, {
                    pathname: 'restoration',
                    search: null,
                    query: queryToPass
                })
            ),
            registration_url: url.format(
                Object.assign({}, currentUrlObj, {
                    pathname: 'registration',
                    search: null,
                    query: queryToPass
                })
            ),
            bgNumber: String((Math.floor(new Date().getTime() / 1000 / 60 / 10) % 18) + 1),
            experiments: res.locals.experiments || {
                flags: [],
                flagsString: '',
                boxes: '',
                encodedBoxes: ''
            },
            clean: queryToPass.clean,
            fretpath: queryToPass.fretpath,
            from: queryToPass.from,
            retpath,
            backpath
        },
        social: {
            providers: JSON.parse(
                JSON.stringify(res.locals.socialProviders.providers.slice().filter((i) => i.enabled))
            ),
            brokerPath,
            brokerParams: config.brokerParams,
            showAllSettings: false
        },
        settings: {
            tld,
            help: config.paths.help || {},
            lang: res.locals.language,
            avatar: config.paths.avatar,
            intranet: process.env.INTRANET === 'intranet',
            env: {
                type: process.env.NODE_ENV,
                name: process.env.INTRANET
            },
            accountsUrl: config.paths.accountsUrl,
            staticPath: config.paths.static,
            version: config.version,
            authCustomsStatic: config.paths.authCustomsStatic,
            authCustomsVersion
        },
        metrics: {
            header: 'Новый домик',
            experiments: res.locals.experiments ? res.locals.experiments.encodedBoxes : ''
        },
        monitoring: {
            page: 'auth.new'
        },
        customs: {
            display: null,
            socialButtonsWithText: false,
            socialExtended: false,
            socialScope: null,
            minimal: false,
            tagline: ''
        },
        captcha: {
            loading: false,
            loadingAudio: false,
            playing: false,
            type: 'text',
            key: null,
            imageUrl: null,
            introSound: null,
            captchaSound: null
        }
    };
    const pddDomain = res.locals.pdd_domain || req.body.pdd_domain || req.query.pdd_domain;
    const social = req.body.social || req.query.social;
    const display = req.body.display || req.query.display;
    const requestedUid = req.body.uid || req.query.uid || null;

    storeDraft.settings.ua = res.locals.ua || {};

    if (apiRequestsResult.validateBackpath && apiRequestsResult.validateBackpath.retpath) {
        const retpath = apiRequestsResult.validateBackpath.retpath;

        storeDraft.common.backpath = retpath;
    }

    const oneDomik = {
        track_id: apiRequestsResult.authPasswordSubmit && apiRequestsResult.authPasswordSubmit.track_id,
        csrf_token: apiRequestsResult.authPasswordSubmit && apiRequestsResult.authPasswordSubmit.csrf_token,
        suggestedAccounts: (apiRequestsResult.authSuggest && apiRequestsResult.authSuggest.accounts) || [],
        authorizedAccounts: [],
        unitedAccounts: {},
        inputLogins: apiRequestsResult.authSuggestGetInputLogin || null,
        mode: 'edit',
        focused: false,
        processedAccount: null,
        passwordType: 'password',
        isExpanded: false,
        isAccountListEditing: false,
        loginIsEmpty: true,
        passwordIsEmpty: true,
        captchaIsEmpty: true,
        captchaRequired: false,
        formIsSubmitted: false,
        formIsUpgraded: false,
        submitCounter: 0,
        form: {
            login: '',
            password: '',
            captcha_answer: '',
            pdd_domain: pddDomain
        }
    };

    if (bbRequestsResult) {
        oneDomik.authorizedAccounts = bbRequestsResult.accounts;
        oneDomik.authorizedAccountsDefaultUid = bbRequestsResult.default_uid;
        oneDomik.canAddMore = bbRequestsResult['can-add-more'];

        bbRequestsResult.accounts.forEach(function(acc) {
            oneDomik.unitedAccounts[acc.uid] = acc;
        });
    }

    if (oneDomik.suggestedAccounts.length) {
        oneDomik.suggestedAccounts.forEach(function(acc) {
            const account = acc.account;

            if (oneDomik.unitedAccounts[account.uid]) {
                return;
            }

            if (pddDomain && account.login && account.login.search(pddDomain) === -1) {
                return;
            }

            oneDomik.unitedAccounts[account.uid] = {
                uid: String(account.uid),
                avatarId: account.display_name.default_avatar,
                login: account.login,
                name: account.display_name.name,
                displayName: account.display_name.name || account.display_login,
                displayLogin: account.display_login || account.login,
                preferred_auth_method: acc.preferred_auth_method,
                allowed_auth_methods: acc.allowed_auth_methods
            };
        });
    }

    if (!Object.keys(oneDomik.unitedAccounts).length) {
        oneDomik.mode = 'addingAccount';
        oneDomik.focused = true;
    }

    if (!Object.keys(oneDomik.authorizedAccounts).length && Object.keys(oneDomik.suggestedAccounts).length === 1) {
        oneDomik.mode = 'addingAccount';
        oneDomik.focused = true;
    }

    if (req.query.mode === 'qr') {
        oneDomik.mode = 'magic';
    }

    if (req.query.mode === 'edit') {
        oneDomik.mode = 'edit';
    }

    if (req.query.mode === 'add-user') {
        oneDomik.mode = 'addingAccount';
        oneDomik.focused = true;
        oneDomik.needEmpty = true;
    }

    if (res.submitErrors) {
        oneDomik.errors = res.submitErrors[0];
        oneDomik.captchaRequired = ['captcha.required', 'captcha.invalid'].indexOf(oneDomik.errors) > -1;
    }

    if (req.body.login || req.query.login) {
        oneDomik.form.login = req.body.login || req.query.login;
        oneDomik.mode = 'addingAccount';
        oneDomik.focused = true;
    }

    if (requestedUid) {
        if (oneDomik.suggestedAccounts.length) {
            oneDomik.suggestedAccounts.forEach(function(acc) {
                const account = acc.account;

                if (
                    account &&
                    String(account.uid) === requestedUid &&
                    oneDomik.unitedAccounts[account.uid].status !== 'VALID'
                ) {
                    oneDomik.mode = 'addingAccount';
                    oneDomik.focused = true;
                    oneDomik.processedAccount = oneDomik.unitedAccounts[account.uid];
                }
            });
        }

        if (!oneDomik.processedAccount && Object.keys(oneDomik.suggestedAccounts).length === 1) {
            oneDomik.mode = 'addingAccount';
            oneDomik.focused = true;
            oneDomik.needEmpty = true;
        }
    }

    if (res.state === 'rfc_totp' || state === 'rfc_totp') {
        oneDomik.mode = 'rfc_totp';
        oneDomik.focused = true;
    }

    if (res.state === 'email_code' || state === 'email_code') {
        oneDomik.mode = 'email_code';
        oneDomik.focused = true;
    }

    if (display === 'popup' || display === 'touch') {
        storeDraft.customs.display = display;
    }

    if (social === 'extended') {
        storeDraft.customs.socialExtended = true;
    }

    if (process.env.INTRANET === 'intranet') {
        storeDraft.common.bgNumber = `100${String((Math.floor(new Date().getTime() / 1000 / 60 / 10) % 5) + 1)}`;
    }

    storeDraft.one_domik = oneDomik;

    res.locals.store = storeDraft;
    res.locals.store.settings.langlist = res.locals.langlist || [];
    res.locals.store.common.csrf = res.locals.csrf || '';

    return next();
}

module.exports = [getSocialProviders, getStore];
