const apiSetup = require('../../common/apiSetup');
const apiRequest = require('./apiRequest');

module.exports = [
    (req, res, next) => {
        delete req.body.track_id;
        return next();
    },
    apiSetup,
    (req, res, next) => {
        // новый параметр для authPasswordSubmit, нужен не всегда
        // https://st.yandex-team.ru/PASSP-24684
        res.withCode = true;

        return next();
    },
    apiRequest('authPasswordSubmit'),
    function(req, res, next) {
        const authPasswordSubmit = res.locals.result.authPasswordSubmit;

        if (!authPasswordSubmit) {
            return next(['internal']);
        }

        return res.json({
            status: 'ok',
            track_id: authPasswordSubmit.track_id,
            csrf_token: authPasswordSubmit.csrf_token,
            user_code: authPasswordSubmit.user_code
        });
    },
    // eslint-disable-next-line no-unused-vars
    function(err, req, res, next) {
        res.json({
            status: 'error',
            errors: err
        });
    }
];
