module.exports = function renderPage(req, res) {
    const locals = res.locals;
    const lang = locals.language;
    const common = locals.store.common;
    const oneDomik = locals.store.one_domik;
    const settings = locals.store.settings;
    const data = Object.assign({}, req.query, req.body);
    const experimentFlags = res.locals.experiments && res.locals.experiments.flagsString;
    const experimentBoxes = res.locals.experiments && res.locals.experiments.boxes;

    req.api.statboxLogger({
        action: 'opened',
        mode: 'one_domik',
        opened_state: oneDomik.mode,
        track_id: common.track_id || null,
        host: req.hostname,
        referer: req.headers.referer || null,
        ip: req.headers['x-real-ip'],
        user_agent: req.headers['user-agent'],
        yandexuid: res._yandexuid || req.cookies.yandexuid,
        is_mobile: String(settings.ua && settings.ua.isMobile),
        login: data.login || null,
        origin: data.origin || null,
        from: data.from || null,
        default_uid: oneDomik.authorizedAccountsDefaultUid || null,
        url: req.url,
        auth_accounts: String(oneDomik.authorizedAccounts.length),
        sugg_accounts: String(oneDomik.suggestedAccounts.length),
        retpath: data.retpath || null,
        experiment_flags: experimentFlags,
        experiment_boxes: experimentBoxes
    });

    res.render(`auth.new.${lang}.jsx`);
};
