const passportApiSetup = require('../common/passportApiSetup');
const langSetup = require('../common/langSetup');
const validateCSRF = require('../common/validateCSRF');
const PLog = require('plog');

module.exports = [
    langSetup,
    passportApiSetup,
    validateCSRF,
    (req, res) => {
        req._passportApi
            .additionalDataAsk()
            .then((result) => {
                const answer = {
                    status: 'ok',
                    csrf_token: res.locals.csrf_token,
                    track_id: result.track_id,
                    state: result.state,
                    action: result.action
                };

                answer[result.state] =
                    (result.data && result.data[0]) ||
                    (result.addresses && result.addresses[0]) ||
                    (result.profiles && result.profiles[0]);

                if (result.state === 'phone' && result.action === 'add') {
                    answer.phone = {
                        number: '',
                        id: ''
                    };
                }

                if (result.state === 'email' && result.action !== 'add' && answer.email) {
                    try {
                        answer.email = req._controller.decodePunycodeEmail(answer.email);
                    } catch (e) {
                        return res.json({
                            status: 'error',
                            errors: ['email.invalid']
                        });
                    }
                }

                return res.json(answer);
            })
            .catch((errors) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('auth.new.additionalDataAsk')
                    .write(errors);

                return res.json(errors._response);
            });
    }
];
