const passportApiSetup = require('../common/passportApiSetup');
const langSetup = require('../common/langSetup');
const validateCSRF = require('../common/validateCSRF');
const PLog = require('plog');

module.exports = [
    langSetup,
    passportApiSetup,
    validateCSRF,
    (req, res) => {
        const {user_declined: userDeclined, track_id: trackId, uid} = req.body;

        req._passportApi
            .additionalDataFreeze(userDeclined, trackId, uid)
            .then(() => res.json({status: 'ok'}))
            .catch((errors) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('auth.new.additionalDataFreeze')
                    .write(errors);

                return res.json(errors._response);
            });
    }
];
