const apiSetup = require('../common/apiSetup');
const validateCSRF = require('../common/validateCSRF');

exports.checkMagicLetterStatus = [
    apiSetup,
    validateCSRF,
    (req, res, next) => {
        req.api
            .checkStatusForAuthWithLetter(req.body.track_id)
            .then((result) => {
                const {body} = result;
                const isAuthChallengeRequired = body.state && body.state === 'auth_challenge';

                if (body.status === 'ok' && body.magic_link_confirmed && !isAuthChallengeRequired) {
                    return next();
                }

                res.json(body || result);
            })
            .catch((errors) =>
                res.json({
                    status: 'error',
                    errors: errors || []
                })
            );
    },
    (req, res) => {
        req.api
            .bundleSession({track_id: req.body.track_id, retpath: req.body.retpath})
            .then(({body}) => {
                const {status, errors = [], retpath, track_id} = body;

                if (status !== 'ok') {
                    return res.json({
                        status,
                        errors
                    });
                }

                req._controller.augmentResponse(body);

                return res.json({
                    status: 'ok',
                    magic_link_confirmed: true,
                    retpath,
                    track_id
                });
            })
            .catch((errors) =>
                res.json({
                    status: 'error',
                    errors: errors || []
                })
            );
    }
];

exports.route = function(app) {
    app.post('/auth/letter/status/', this.checkMagicLetterStatus);
};
