const apiSetup = require('../common/apiSetup');
const validateCSRF = require('../common/validateCSRF');
const apiRequest = require('./apiRequest');
const multiAuth = require('./multiAuth');

module.exports.route = [
    apiSetup,
    validateCSRF,
    multiAuth('authLogout', true),
    (req, res, next) => {
        req.body._uid = req.body.uid;

        next();
    },
    apiRequest('authSuggestForget'),
    (req, res) => res.json({status: 'ok'})
];
