const apiSetup = require('../common/apiSetup');
const apiRequest = require('./apiRequest.js');

module.exports.route = [
    (req, res, next) => {
        delete req.body.track_id;
        return next();
    },
    apiSetup,
    apiRequest('authPasswordSubmit'),
    (req, res, next) => {
        const authPasswordSubmit = res.locals.result.authPasswordSubmit;

        if (!authPasswordSubmit) {
            return next(['internal']);
        }

        return res.json({
            status: 'ok',
            track_id: authPasswordSubmit.track_id,
            csrf_token: authPasswordSubmit.csrf_token
        });
    },
    // eslint-disable-next-line no-unused-vars
    (err, req, res, next) => {
        res.json({
            status: 'error',
            errors: err
        });
    }
];
