const apiSetup = require('../common/apiSetup');
const validateCSRF = require('../common/validateCSRF');

module.exports = [
    apiSetup,
    validateCSRF,
    (req, res) => {
        req.api
            .authSendLinkLetter(req.body)
            .then((result = {}) => {
                const updatedResult = Object.assign({}, result.body);

                if (updatedResult.code) {
                    updatedResult.code = [...updatedResult.code];
                }

                res.json(updatedResult);
            })
            .catch((errors) =>
                res.json({
                    status: 'error',
                    errors: errors || []
                })
            );
    }
];
