const PLog = require('plog');
const {errorHandler} = require('./errorHandler');

function doSubmit(req, res, next) {
    const {retpath, origin} = {...req.nquery, ...req.body};
    const query = {};

    const storeDraft = res.locals.store || (res.locals.store = {});
    const authStore = storeDraft.auth || (storeDraft.auth = {});

    retpath && (query.retpath = retpath);
    origin && (query.origin = origin);
    query['track_id'] = req.api.track();
    storeDraft.common['track_id'] = query['track_id'];

    return req.api
        .passwordConfirmSubmit(query)
        .then(function(result) {
            result = result.body;

            storeDraft.common['track_id'] = result.track_id;
            storeDraft.common['csrf_token'] = result.csrf_token;

            if (result.status === 'ok' && result.account) {
                authStore.processedAccount = result.account;
            }

            res.account = result.account;

            if (result.status === 'ok') {
                return next();
            } else {
                PLog.warn()
                    .logId(req.logID)
                    .type('authVerifyDoSubmit')
                    .write(result);

                return errorHandler(result.errors, req, res, next);
            }
        })
        .catch((err) => {
            PLog.warn()
                .logId(req.logID)
                .type('authVerifyDoSubmit')
                .write(err);

            if (err && (Array.isArray(err.errors) || (err.body && Array.isArray(err.body.errors)))) {
                return errorHandler(Array.isArray(err.errors) ? err.errors : err.body.errors, req, res, next);
            }
            next(err);
        });
}

module.exports = {
    doSubmit
};
