const PLog = require('plog');
const url = require('url');
const {processErrors} = require('../../../lib/passport-errors');

function errorHandler(err, req, res, next) {
    PLog.warn()
        .logId(req.logID)
        .type('passwordConfirmSubmit error handler')
        .write(err);

    const lang = res.locals.language;
    const {retpath, origin} = Object.assign({}, req.nquery, req.body);
    const query = {retpath, origin};

    if (Array.isArray(err) && err.some((error) => ['action.not_required', 'account.auth_passed'].includes(error))) {
        return res.redirect(
            url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname,
                pathname: 'redirect',
                query: {
                    retpath: query.retpath
                }
            })
        );
    }

    if (
        Array.isArray(err) &&
        err.some((error) =>
            ['account.disabled', 'account.not_found', 'account.disabled_on_deletion', 'sessionid.invalid'].includes(
                error
            )
        )
    ) {
        return res.redirect(
            url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname,
                pathname: 'auth',
                query
            })
        );
    }

    if (Array.isArray(err) && err.includes('account.without_password')) {
        return res.redirect(
            url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname,
                pathname: 'profile/upgrade',
                query: {
                    origin: query.origin || 'passport_profile',
                    retpath: query.retpath
                }
            })
        );
    }

    if (Array.isArray(err) && err.includes('captcha.required')) {
        res.locals.store.form.captchaRequired = true;
    }

    if (Array.isArray(err) && err.includes('password.not_matched') && res.account && res.account.is_2fa_enabled) {
        err[err.indexOf('password.not_matched')] = 'password.not_matched.2fa';
    }

    const errors = processErrors(err, lang, {});

    if (errors.length) {
        res.locals.store.form.errors.password = {code: errors[0].code, text: errors[0].msg};
    }

    return next();
}

module.exports = {
    errorHandler
};
