const checkAuth = require('../../common/checkAuth');
const {captchaGenerate} = require('../../common/captchaGenerate');
const apiRequest = require('../apiRequest');
const {AUTH_REG_COMPLETE_LOG_TYPE} = require('../../authRegComplete/constants');
const {maybeAuthVerify} = require('./maybeAuthVerify');
const {getTrack} = require('./getTrack');
const {doSubmit} = require('./doSubmit');

function maybeRunAuthVerify() {
    return [
        checkAuth,
        apiRequest('validateRetpath'),
        getTrack,
        doSubmit,
        captchaGenerate(AUTH_REG_COMPLETE_LOG_TYPE)
    ].map((handler) => maybeAuthVerify(handler));
}

module.exports = {
    maybeAuthVerify,
    maybeRunAuthVerify
};
