const url = require('url');
const PLog = require('plog');

function doCommit(req, res) {
    const {retpath, origin} = {...req.nquery, ...req.body};
    const query = {retpath, origin};

    return req.api
        .passwordConfirmCommit({
            track_id: req.body.trackId,
            password: req.body.password
        })
        .then(function(result) {
            if (result.body.status !== 'ok') {
                throw result;
            }

            if (result.body && result.body.state) {
                return res.json({
                    status: 'ok',
                    redirectPath: url.format({
                        protocol: req.headers['x-real-scheme'],
                        hostname: req.hostname,
                        pathname: 'auth',
                        query: {
                            track_id: result.body.track_id,
                            retpath: result.body.retpath
                        }
                    })
                });
            }

            return req.api
                .bundleSession({
                    track_id: result.body.track_id,
                    retpath: req.body.retpath
                })
                .then(function(bundleSessionResult) {
                    const body = bundleSessionResult.body;

                    req._controller.augmentResponse(body);

                    if (body.status !== 'ok') {
                        throw bundleSessionResult;
                    }

                    if (body.cookies) {
                        return res.json({
                            status: 'ok',
                            redirectPath: url.format({
                                protocol: req.headers['x-real-scheme'],
                                hostname: req.hostname,
                                pathname: '/auth/finish/',
                                query: {
                                    track_id: body.track_id,
                                    retpath: body.retpath
                                }
                            })
                        });
                    } else if (body.retpath) {
                        return res.json({
                            status: 'ok',
                            redirectPath: body.retpath
                        });
                    }

                    return res.json({
                        status: 'ok',
                        redirectPath: url.format({
                            protocol: req.headers['x-real-scheme'],
                            hostname: req.hostname,
                            pathname: 'profile'
                        })
                    });
                });
        })
        .catch(function(err) {
            PLog.warn()
                .logId(req.logID)
                .type('authVerifyDoCommit')
                .write(err);

            const errors = err && err.body && err.body.errors;
            const account = err && err.body && err.body.account;

            let redirectPath;

            if (
                Array.isArray(errors) &&
                errors.some((error) => ['action.not_required', 'account.auth_passed'].includes(error))
            ) {
                redirectPath = url.format({
                    protocol: req.headers['x-real-scheme'],
                    hostname: req.hostname,
                    pathname: 'redirect',
                    query: {
                        retpath: query.retpath
                    }
                });
            }

            if (
                Array.isArray(errors) &&
                errors.some((error) =>
                    [
                        'account.disabled',
                        'account.not_found',
                        'account.disabled_on_deletion',
                        'sessionid.invalid'
                    ].includes(error)
                )
            ) {
                redirectPath = url.format({
                    protocol: req.headers['x-real-scheme'],
                    hostname: req.hostname,
                    pathname: 'auth',
                    query
                });
            }

            if (Array.isArray(errors) && errors.some((error) => ['account.without_password'].includes(error))) {
                redirectPath = url.format({
                    protocol: req.headers['x-real-scheme'],
                    hostname: req.hostname,
                    pathname: 'profile/upgrade',
                    query: {
                        origin: query.origin || 'passport_profile',
                        retpath: query.retpath
                    }
                });
            }

            if (Array.isArray(errors) && errors.includes('password.not_matched') && account && account.is_2fa_enabled) {
                errors[errors.indexOf('password.not_matched')] = 'password.not_matched.2fa';
            }

            if (redirectPath) {
                res.json({
                    status: 'ok',
                    redirectPath
                });
            } else {
                res.json({
                    status: 'error',
                    errors: errors || []
                });
            }
        });
}

module.exports = {
    doCommit
};
