const passportApiSetup = require('../common/passportApiSetup');
const langSetup = require('../common/langSetup');
const validateCSRF = require('../common/validateCSRF');
const PLog = require('plog');

module.exports = [
    langSetup,
    passportApiSetup,
    validateCSRF,
    (req, res) => {
        const {code, track_id: trackId} = req.body;

        req._passportApi
            .bindSimpleOrConfirmBoundPhoneCommit(code, trackId)
            .then(() => res.json({status: 'ok'}))
            .catch((errors) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('auth.new.bindSimpleOrConfirmBoundPhoneCommit')
                    .write(errors);

                return res.json(errors._response);
            });
    }
];
