const apiSetup = require('../common/apiSetup');
const passportApiSetup = require('../common/passportApiSetup');
const getYaExperimentsFlags = require('../common/getYaExperimentsFlags');
const langSetup = require('../common/langSetup');
const validateCSRF = require('../common/validateCSRF');
const PLog = require('plog');

module.exports = [
    langSetup,
    passportApiSetup,
    apiSetup,
    validateCSRF,
    getYaExperimentsFlags,
    (req, res, next) => {
        if (req.body.isCodeWithFormat) {
            req.body.code_format = 'by_3_dash';
        }

        return next();
    },
    async (req, res) => {
        const {display_language: displayLanguage, track_id: trackId, code_format, phone_id} = req.body;

        let number = req.body.number;

        if (phone_id) {
            const yasmsData = await req.api.yasmsGetState({filter: false});
            const {account = {}} = yasmsData;
            const {phones} = account;

            if (phones) {
                const phone = phones[phone_id];

                if (phone && phone.number.international) {
                    number = phone.number.international;
                }
            }
        }

        return req.api
            .params('country')
            .then((response = {}) => {
                const {body = {}} = response;
                const country = body.country && body.country[0];

                return req._passportApi
                    .bindSimpleOrConfirmBoundPhoneSubmit({
                        number,
                        trackId,
                        displayLanguage,
                        country,
                        code_format
                    })
                    .then((result) =>
                        res.json({
                            status: 'ok',
                            number: result.number
                        })
                    )
                    .catch((errors) => {
                        PLog.warn()
                            .logId(req.logID)
                            .type('auth.new.bindSimpleOrConfirmBoundPhoneSubmit')
                            .write(errors);

                        return res.json(errors._response);
                    });
            })
            .catch((errors) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('auth.new.bindSimpleOrConfirmBoundPhoneSubmit')
                    .write(errors);

                return res.json(errors);
            });
    }
];
