const PLog = require('plog');

module.exports = function(req, res, next) {
    const trackId = (req.query || {}).track_id || (req.body || {}).track_id;

    if (trackId) {
        return req.api
            .readTrack(trackId)
            .then(function(trackData = {}) {
                const uid = trackData.body && trackData.body.uid;

                if (!uid) {
                    return next();
                }

                req._controller
                    .getAuth()
                    .userInfo({
                        uid,
                        attributes: 200
                    })
                    .then((response = {}) => {
                        const {attributes = {}} = response;

                        res.locals.isSms2faChallenge = Boolean(attributes['200']);
                        return next();
                    })
                    .catch((error) => {
                        new PLog(req._controller.getLogId(), 'passport', 'challenges', 'checkSms2faChallenge')
                            .warn()
                            .write('userInfo', error);
                        return next();
                    });
            })
            .catch((error) => {
                new PLog(req._controller.getLogId(), 'passport', 'challenges', 'checkSms2faChallenge')
                    .warn()
                    .write('readTrack', error);
                return next();
            });
    }
    return next();
};
