const apiSetup = require('../../common/apiSetup');
const validateCSRF = require('../../common/validateCSRF');
const createSession = require('../../common/createSession');

module.exports = [
    apiSetup,
    validateCSRF,
    function(req, res, next) {
        const {challenge, answer, track_id: trackId} = req.body;

        if (!trackId) {
            return res.json({
                status: 'error',
                error: ['track_id.empty']
            });
        }

        if (!['phone_confirmation', 'email_code'].includes(challenge) && !answer) {
            return res.json({
                status: 'error',
                error: ['challenge.not_passed']
            });
        }

        req.api
            .challengesCommit(req.body)
            .then(function(result = {}) {
                const {body} = result;

                if (body.status === 'ok') {
                    return next();
                }

                return res.json({status: 'error', error: ['error-internal']});
            })
            .catch(function(error) {
                return res.json({status: 'error', error});
            });
    },
    (req, res, next) =>
        req.api
            .readTrack(req.body.track_id)
            .then(({body: {social_task_id: socialTaskId, status} = {}}) => {
                if (status === 'ok') {
                    return socialTaskId ? res.send({status: 'ok', isSocial: true}) : next();
                }

                return res.json({status: 'error', error: ['error-internal']});
            })
            .catch((error) => res.json({status: 'error', error})),
    createSession
];
