const apiSetup = require('../../common/apiSetup');
const validateCSRF = require('../../common/validateCSRF');

module.exports = [
    apiSetup,
    validateCSRF,
    (req, res) => {
        const {trackId, code, uid} = req.body;

        if (!trackId) {
            return res.json({
                status: 'error',
                error: ['track_id.empty']
            });
        }

        req.api
            .confirmEmailCode({trackId, code, uid})
            .then(() => res.json({status: 'ok'}))
            .catch((error) => res.json({status: 'error', error}));
    }
];
