const apiSetup = require('../../common/apiSetup');
const validateCSRF = require('../../common/validateCSRF');
const checkSms2faChallenge = require('./checkSms2faChallenge');

module.exports = [
    apiSetup,
    validateCSRF,
    checkSms2faChallenge,
    function(req, res) {
        const trackId = req.body.track_id;

        if (!trackId) {
            return res.json({
                status: 'error',
                error: ['track_id.empty']
            });
        }

        req.api
            .challengesSubmit({
                track_id: trackId
            })
            .then(function(result = {}) {
                if (!result.body && !result.body.challenges_enabled) {
                    return res.json({status: 'error'});
                }

                const {
                    body: {challenges_enabled: challengeInfo, default_challenge: challengeType}
                } = result;
                const availableChallenges = Object.keys(challengeInfo);
                const defaultChallengeData = {
                    challengeType,
                    hint: challengeInfo[challengeType].hint,
                    fieldValue: '',
                    errorText: '',
                    errorCode: '',
                    isSms2faChallenge: res.locals.isSms2faChallenge
                };

                if (challengeType === 'phone_confirmation' || challengeType === 'push_2fa') {
                    const {phone_confirmation: {phone_id: phoneId = null} = {}} = challengeInfo;

                    defaultChallengeData.phoneId = phoneId;
                }

                if (availableChallenges.length > 1) {
                    const updatedDefaultChallenge = availableChallenges.find((item) => item !== challengeType);

                    defaultChallengeData.alternative = {
                        challengeType: updatedDefaultChallenge,
                        hint: challengeInfo[updatedDefaultChallenge].hint
                    };
                }

                return res.json({
                    status: 'ok',
                    challenge: defaultChallengeData
                });
            })
            .catch(function(error) {
                return res.json({status: 'error', error});
            });
    }
];
