const apiSetup = require('../../common/apiSetup');
const validateCSRF = require('../../common/validateCSRF');

module.exports = [
    apiSetup,
    validateCSRF,
    (req, res) => {
        const trackId = req.body.track_id;

        if (!trackId) {
            return res.json({
                status: 'error',
                error: ['track_id.empty']
            });
        }

        req.api
            .sendPush(trackId)
            .then(() => res.json({status: 'ok'}))
            .catch((error) => res.json({status: 'error', error}));
    }
];
