const PLog = require('plog');

module.exports = function checkSMS2faEnabled(req, res, next) {
    const trackId = req.body.track_id;

    if (!trackId) {
        return next();
    }

    return req.api
        .readTrack(req.body.track_id)
        .then(function(trackData = {}) {
            const uid = trackData.body && trackData.body.uid;

            req._controller
                .getAuth()
                .userInfo({
                    uid,
                    attributes: 200
                })
                .then((response = {}) => {
                    const {attributes = {}} = response;

                    res.locals.isSms2faEnabled = Boolean(attributes['200']);
                    return next();
                })
                .catch((error) => {
                    PLog.warn()
                        .logId(req.logID)
                        .type('checkSMS2faEnabled')
                        .write(error);

                    return next();
                });
        })
        .catch((error) => {
            PLog.warn()
                .logId(req.logID)
                .type('getTrack')
                .write(error);
            return next();
        });
};
