const PLog = require('plog');
const url = require('url');
const apiSetup = require('../../common/apiSetup');
const validateCSRF = require('../../common/validateCSRF');
const getYaExperimentsFlags = require('../../common/getYaExperimentsFlags');
const checkSMS2faEnabled = require('./checkSms2FAEnabled');

module.exports = [
    apiSetup,
    validateCSRF,
    getYaExperimentsFlags,
    checkSMS2faEnabled,
    getQuestion,
    (req, res) => {
        return req.api
            .authSubmit('/1/bundle/auth/password/get_state/', {track_id: req.body.track_id})
            .then((response = {}) => {
                const currentUrlObj = url.parse(url.format(req._controller.getUrl()), true);
                const passwordStateBody = response.body;
                const hintQuestion = res.locals.userQuestion || null;
                const isNewPasswordTextsExp =
                    res.locals.experiments && res.locals.experiments.flags.includes('password-pwned-exp');

                if (passwordStateBody && passwordStateBody.status === 'ok') {
                    const {validation_method, change_password_reason, account = {}, number = {}} = passwordStateBody;
                    /* change_password_reason from backend:
-                        - password_pwned
-                        - password_common
-                        - password_weak
-                        - password_flushed
-                        - account_hacked
-                        - password_expired
-                  */
                    const hasExpiredPassword = change_password_reason === 'password_expired';
                    const info = {
                        status: 'ok',
                        state: {
                            step: 'text',
                            validationMethod: validation_method,
                            reason: isNewPasswordTextsExp
                                ? getReason(
                                      change_password_reason,
                                      Boolean(number.masked_international || hintQuestion)
                                  )
                                : change_password_reason,
                            isConnectUser: account.is_workspace_user,
                            isYandexoid: account.is_yandexoid,
                            isPhoneOperationConflict: false,
                            hasSms2faEnabled: res.locals.isSms2faEnabled,
                            hasSms2faUpdated: false,
                            number: number.masked_international || null,
                            question: hintQuestion,
                            semiautoUrl: url.format(
                                Object.assign({}, currentUrlObj, {
                                    pathname: '/restoration/fallback',
                                    query: {
                                        track_id: req.body.track_id
                                    }
                                })
                            )
                        }
                    };

                    if (isNewPasswordTextsExp) {
                        info.state.step = 'textExp';
                    } else {
                        if (change_password_reason !== 'password_weak') {
                            if (hintQuestion) {
                                info.state.reason = 'account_hacked_no_phone';
                            }

                            if (number.masked_international) {
                                info.state.reason = 'account_hacked_phone';
                            }

                            if (!validation_method && !info.state.question) {
                                info.state.reason = 'account_hacked';
                            }

                            if (hasExpiredPassword) {
                                info.state.reason = 'password_expired';
                            }
                        }
                    }

                    return res.json(info);
                }

                return res.json({status: 'error', error: 'global'});
            })
            .catch((error = {}) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('getPasswordState')
                    .write(error);
                return res.json({status: 'error', error});
            });
    }
];

function getReason(originalReason, hasValidationMethod) {
    const changePwdReasons = ['password_weak', 'password_expired'];

    if (changePwdReasons.includes(originalReason)) {
        return 'changePassword';
    }

    if (hasValidationMethod) {
        return 'accountRestricted';
    }

    return 'restorationForm';
}

function getQuestion(req, res, next) {
    return req.api
        .getHistoryQuestions({track_id: req.body.track_id})
        .then((result = {}) => {
            const {body = {}} = result;

            if (body.questions && body.questions.length) {
                res.locals.userQuestion = body.questions.length && body.questions[0];
            }

            return next();
        })
        .catch((error = {}) => {
            PLog.warn()
                .logId(req.logID)
                .type('getPasswordState getQuestion')
                .write(error);
            return next();
        });
}
