const getCustomConfigByRequest = require('../common/getCustomConfigByRequest');

module.exports = function chooseMode(req, res, next) {
    const authDraft = res.locals.store.auth;
    const requestedUid = req.body.uid || req.query.uid || null;
    const requestedLogin = req.body.login || req.query.login || null;
    const requestedMode = req.body.mode || req.query.mode || null;
    const isAuthLetterLink = req.query.secret;
    const isBroAutologin = req.isBroAutologin;

    const hasUnitedAccounts = Object.keys(authDraft.unitedAccounts).length !== 0;
    const hasAuthorizedAccounts = Object.keys(authDraft.authorizedAccounts).length !== 0;
    const hasSuggestedAccounts = Object.keys(authDraft.suggestedAccounts).length !== 0;
    const hasOnlyOneSuggestedAccount = !hasAuthorizedAccounts && Object.keys(authDraft.suggestedAccounts).length === 1;
    const customsConfig = getCustomConfigByRequest(req) || {};
    const {experiments = {}} = res.locals;
    const {flags = []} = experiments;

    let mode = '';

    const {pathname} = req._controller.getUrl() || {};

    if (flags.includes('new-auth-verify-design') && pathname.includes('/auth/verify')) {
        authDraft.mode = 'verify';
        res.locals.mode = authDraft.mode;
        return next();
    }

    if (pathname.includes('/auth/child')) {
        authDraft.mode = 'childish';
        return next();
    }

    if (requestedMode === 'enable-key-2fa' || pathname.includes('/auth/enable-key-2fa')) {
        authDraft.mode = 'enableKey2FA';
        res.locals.mode = authDraft.mode;
        return next();
    }

    if (requestedMode === 'add-user') {
        res.locals.mode = 'addingAccount';
        return next();
    }

    if (requestedMode === 'upgrade' || /^\/auth\/complete\/?$/.test(pathname)) {
        res.locals.mode = 'upgrade';
        return next();
    }

    if (res.state === 'rfc_totp') {
        res.locals.mode = 'rfc_totp';
        return next();
    }

    if (requestedMode === 'qr') {
        res.locals.mode = 'magic';
        return next();
    }

    if (hasUnitedAccounts && Object.keys(authDraft.unitedAccounts).length > 0) {
        mode = 'edit';
    }

    if (hasUnitedAccounts && hasOnlyOneSuggestedAccount && !requestedUid) {
        mode = 'welcome';
    }

    if (requestedUid) {
        if (hasSuggestedAccounts) {
            authDraft.suggestedAccounts.forEach(function(acc) {
                const account = acc.account;

                if (
                    account &&
                    String(account.uid) === requestedUid &&
                    authDraft.unitedAccounts[account.uid].status !== 'VALID'
                ) {
                    mode = 'welcome';
                }
            });
        }

        if (hasUnitedAccounts) {
            Object.keys(authDraft.unitedAccounts).forEach(function(uid) {
                const account = authDraft.unitedAccounts[uid];

                if (
                    account &&
                    String(account.uid) === requestedUid &&
                    authDraft.unitedAccounts[account.uid].status === 'VALID'
                ) {
                    mode = 'edit';
                }
            });
        }
    }

    if (requestedLogin) {
        mode = 'addingAccount';
        if (hasUnitedAccounts && !isBroAutologin) {
            Object.keys(authDraft.unitedAccounts).forEach(function(uid) {
                const account = authDraft.unitedAccounts[uid];

                if (account && String(account.login) === requestedLogin) {
                    mode = 'welcome';
                }
            });
        }

        if (isBroAutologin) {
            mode = 'welcome';
        }
    }

    if (isAuthLetterLink) {
        mode = 'authWithLetterLink';
    }

    if (!mode) {
        mode = 'addingAccount';
    }

    if (customsConfig.authModeMap && customsConfig.authModeMap[mode]) {
        mode = customsConfig.authModeMap[mode];
    }

    res.locals.mode = mode;
    return next();
};
