const passportApiSetup = require('../common/passportApiSetup');
const langSetup = require('../common/langSetup');
const validateCSRF = require('../common/validateCSRF');
const PLog = require('plog');

module.exports = [
    langSetup,
    passportApiSetup,
    validateCSRF,
    (req, res) => {
        const {track_id: trackId, key, uid} = req.body;

        req._passportApi
            .confirmEmailByCode(key, trackId, uid)
            .then(() => res.json({status: 'ok'}))
            .catch((errors) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('auth.new.confirmEmailByCode')
                    .write(errors);

                return res.json(errors._response);
            });
    }
];
