const apiSetup = require('../common/apiSetup');
const validateCSRF = require('../common/validateCSRF');

module.exports = [
    apiSetup,
    validateCSRF,
    (req, res) => {
        let handle = 'authWithLetterConfirm';

        if (req.body.isRegister === 'true') {
            handle = 'registerWithLetterConfirm';
        }

        req.api[handle](req.body)
            .then((result) => res.json(result.body || result))
            .catch((errors) =>
                res.json({
                    status: 'error',
                    errors: errors || []
                })
            );
    }
];
