const passportApiSetup = require('../common/passportApiSetup');
const langSetup = require('../common/langSetup');

module.exports = function createAdditionalDataRequestState() {
    return [
        langSetup,
        passportApiSetup,
        (req, res, next) => {
            req._passportApi
                .additionalDataAsk()
                .then((payload) => {
                    const storeDraft = res.locals.store || (res.locals.store = {});
                    const resultStore = storeDraft.additionalDataRequest || (storeDraft.additionalDataRequest = {});

                    Object.assign(resultStore, {
                        status: 'ok',
                        isConfirmationCodeSent: false,
                        isCaptchaRequired: false,
                        errors: [],
                        confirmationCode: '',
                        denyResendUntil: null
                    });

                    if (!(payload && payload.state)) {
                        return next();
                    }

                    const {track_id: trackId} = payload;
                    const availableSocialProviders = ['vk', 'ok', 'tw', 'mr', 'gg', 'fb'];
                    const {ua} = res.locals;
                    const isMobile = (ua.isMobile || ua.isTouch) && !ua.isTablet;

                    if (payload.state === 'social' && payload.action === 'add' && isMobile) {
                        return next();
                    }

                    if (
                        payload.state === 'social' &&
                        payload.action !== 'add' &&
                        Array.isArray(payload.profiles) &&
                        availableSocialProviders.indexOf(payload.profiles[0].provider_code) === -1
                    ) {
                        return next();
                    }

                    Object.assign(resultStore, {
                        state: payload.state,
                        action: payload.action,
                        track_id: trackId
                    });

                    res.locals.track_id = trackId;

                    resultStore[payload.state] =
                        (payload.data && payload.data[0]) ||
                        (payload.addresses && payload.addresses[0]) ||
                        (payload.profiles && payload.profiles[0]);

                    if (payload.state === 'phone') {
                        if (!resultStore.phone) {
                            resultStore.phone = {id: '', number: ''};
                        }

                        resultStore.phone.id = String(resultStore.phone.id);
                        resultStore.phone.number = String(resultStore.phone.number);
                    }

                    if (payload.state === 'email' && payload.action !== 'add' && resultStore.email) {
                        try {
                            resultStore.email = req._controller.decodePunycodeEmail(resultStore.email);
                        } catch (e) {
                            return next(['email.invalid']);
                        }
                    }

                    return next();
                })
                .catch((errors) => next(errors));
        }
    ];
};
