const PLog = require('plog');
const apiRequest = require('./apiRequest.js');
const apiSetup = require('../common/apiSetup');
const multiAuthAccountsSetup = require('../common/multiAuthAccountsSetup').getAccounts;

const originsFromWebview = [
    'disk_app',
    'music_app',
    'telemost_app',
    'telemost_chat_app',
    'autofill',
    'zalogin_app',
    'bnpl_checkout'
];
const originsFromWebviewWithSocialAuth = ['music_app'];

const authSuggestGetInputLogin = [
    apiSetup,
    function(req, res, next) {
        const apiRequestsResult = res.locals.result || {};
        const suggestedAccounts = apiRequestsResult.authSuggest && apiRequestsResult.authSuggest.accounts;
        const uid = Array.isArray(suggestedAccounts) && suggestedAccounts[0] && suggestedAccounts[0].account.uid;

        if (!uid) {
            return next();
        }

        if (!suggestedAccounts || (Array.isArray(suggestedAccounts) && suggestedAccounts.length > 1)) {
            return next();
        }

        return req.api
            .authSuggestGetInputLogin({
                uid
            })
            .then(function(result) {
                if (!apiRequestsResult.authSuggestGetInputLogin) {
                    apiRequestsResult.authSuggestGetInputLogin = {};
                }

                apiRequestsResult.authSuggestGetInputLogin[uid] = result.body.input_login;
                return next();
            })
            .catch(function(err) {
                PLog.warn()
                    .logId(req.logID)
                    .type('auth.v2.authSuggestGetInputLogin')
                    .write(err);

                return next();
            });
    }
];

module.exports = function createAuthState() {
    return [
        (req, res, next) => {
            res.locals.blackboxPlus = true;
            next();
        },
        multiAuthAccountsSetup,
        apiRequest('authSuggest'),
        authSuggestGetInputLogin,
        (req, res, next) => {
            const storeDraft = res.locals.store || (res.locals.store = {});
            const resultStore = storeDraft.auth || (storeDraft.auth = {});
            const experimentFlags = new Set((res.locals.experiments || {}).flags || []);
            const origin = req.query.origin || req.body.origin;

            const apiRequestsResult = res.locals.result || {};
            const bbRequestsResult = res.locals.accounts;

            const pddDomain = res.locals.pdd_domain || req.body.pdd_domain || req.query.pdd_domain;
            const requestedUid = req.body.uid || req.query.uid || null;

            const passwordType = 'password';
            const submitCounter = 0;
            const unitedAccounts = {};

            let authorizedAccounts = [];

            let authorizedAccountsDefaultUid = null;

            let canAddMore = true;

            let defaultAccount = null;

            let needEmpty = false;

            let processedAccount = null;
            const method = 'password';

            const isQRAuthEnabled = experimentFlags.has('qr_exp');
            const isRestoreLoginTextExp = experimentFlags.has('domik_restorelogintxt_exp');

            const form = {
                login: '',
                password: '',
                captcha_answer: '',
                pdd_domain: pddDomain,
                isCanRegister: false,
                isForceOTP: false,
                registrationLogin: '',
                registrationType: '',
                registrationPhoneNumber: '',
                registrationCountry: ''
            };

            const loginError = '';
            const passwordError = '';
            const captchaError = '';
            const magicError = '';

            if (bbRequestsResult) {
                authorizedAccounts = bbRequestsResult.accounts;
                authorizedAccountsDefaultUid = bbRequestsResult.default_uid;
                canAddMore = bbRequestsResult['can-add-more'];

                bbRequestsResult.accounts.forEach(function(acc) {
                    unitedAccounts[acc.uid] = acc;
                });
            }

            let suggestedAccounts = (apiRequestsResult.authSuggest && apiRequestsResult.authSuggest.accounts) || [];

            const inputLogins = apiRequestsResult.authSuggestGetInputLogin || null;

            if (suggestedAccounts.length) {
                suggestedAccounts.forEach(function(acc) {
                    const account = acc.account;
                    const unitedAccount = unitedAccounts[account.uid];

                    if (unitedAccount) {
                        unitedAccount.hasSocial = false;
                        unitedAccount.socialProvider = null;
                        unitedAccount.preferred_auth_method = acc.preferred_auth_method;
                        unitedAccount.allowed_auth_methods = acc.allowed_auth_methods;
                        unitedAccount.defaultEmail = account.default_email
                            ? req._controller.decodePunycodeEmail(account.default_email)
                            : '';
                        unitedAccount.primaryAliasType = account.primary_alias_type;

                        if (unitedAccount.social) {
                            unitedAccount.hasSocial = true;
                            unitedAccount.socialProvider = unitedAccount.social.provider;
                            unitedAccount.preferred_auth_method =
                                acc.preferred_auth_method || `social_${unitedAccount.socialProvider}`;
                            unitedAccount.allowed_auth_methods = [
                                ...acc.allowed_auth_methods,
                                `social_${unitedAccount.socialProvider}`
                            ];
                        }

                        return;
                    }

                    if (pddDomain && account.login && account.login.search(pddDomain) === -1) {
                        return;
                    }

                    const hasSocial = acc.preferred_auth_method && acc.preferred_auth_method.indexOf('social_') === 0;

                    unitedAccounts[account.uid] = {
                        uid: String(account.uid),
                        avatarId: account.display_name.default_avatar,
                        login: account.login,
                        name: account.display_name.name,
                        displayName: account.display_name.name || account.display_login,
                        displayLogin: account.display_login || account.login,
                        preferred_auth_method: acc.preferred_auth_method,
                        allowed_auth_methods: acc.allowed_auth_methods,
                        socialProvider: hasSocial ? acc.preferred_auth_method.replace('social_', '') : null,
                        defaultEmail: account.default_email
                            ? req._controller.decodePunycodeEmail(account.default_email)
                            : '',
                        hasSocial,
                        hasPlus: Boolean(account.has_plus),
                        primaryAliasType: account.primary_alias_type
                    };
                });
            }

            if (req.query.mode === 'add-user') {
                needEmpty = true;
            }

            if (req.body.login || req.query.login) {
                form.login = req.body.login || req.query.login;
            }

            if (req.query.email && req._controller.getUrl().pathname === '/auth/preregister') {
                form.login = req.query.email;
            }

            if (requestedUid) {
                if (suggestedAccounts.length) {
                    suggestedAccounts.forEach(function(acc) {
                        const account = acc.account;

                        if (
                            account &&
                            String(account.uid) === requestedUid &&
                            unitedAccounts[account.uid].status !== 'VALID'
                        ) {
                            processedAccount = unitedAccounts[account.uid];
                        }
                    });
                }

                if (!processedAccount && Object.keys(suggestedAccounts).length === 1) {
                    needEmpty = true;
                }
            }

            defaultAccount = authorizedAccounts.find((o) => o.uid === authorizedAccountsDefaultUid);

            if (!processedAccount && suggestedAccounts.length && !needEmpty) {
                processedAccount = unitedAccounts[suggestedAccounts[0].account.uid];
            }

            if (needEmpty) {
                processedAccount = null;
            }

            if (form.login) {
                processedAccount = null;

                if (Object.keys(unitedAccounts).length) {
                    Object.keys(unitedAccounts).forEach(function(uid) {
                        const account = unitedAccounts[uid];

                        if (account && (account.login === form.login || account.display_login === form.login)) {
                            processedAccount = unitedAccounts[account.uid];
                        }
                    });
                }

                if (req.isBroAutologin) {
                    processedAccount = unitedAccounts['000000'] = {
                        uid: '000000',
                        isAddedAccount: true,
                        avatarId: '0/0-0',
                        login: req.body.login
                    };
                }
            }

            if (originsFromWebview.includes(origin) && !originsFromWebviewWithSocialAuth.includes(origin)) {
                Object.keys(unitedAccounts).forEach((uid) => {
                    const account = unitedAccounts[uid];

                    if (account.socialProvider) {
                        authorizedAccounts = authorizedAccounts.filter((acc = {}) => acc.uid !== uid);
                        suggestedAccounts = suggestedAccounts.filter(({account = {}} = {}) => account.uid !== uid);
                        delete unitedAccounts[uid];
                    }
                });
            }

            Object.assign(resultStore, {
                process_uuid: res.locals.process_uuid,
                isQRAuthEnabled,
                authorizedAccounts,
                form,
                loginError,
                passwordError,
                captchaError,
                magicError,
                inputLogins,
                authorizedAccountsDefaultUid,
                defaultAccount,
                canAddMore,
                method,
                needEmpty,
                passwordType,
                processedAccount,
                submitCounter,
                suggestedAccounts,
                unitedAccounts,
                isRestoreLoginTextExp,
                typeImage2FA: 'image',
                loginFieldType: experimentFlags.has('auth-toggle-input-exp') ? 'phone' : 'login'
            });

            return next();
        }
    ];
};
