module.exports = function(req, res, next) {
    const trackId = req.query && req.query.track_id;
    const state = res.locals.store;

    if (!trackId) {
        return req._controller.redirectToLocalUrl({
            pathname: 'auth'
        });
    }

    req.api
        .challengesSubmit({
            track_id: trackId
        })
        .then((result = {}) => {
            if (!result.body && !result.body.challenges_enabled) {
                return req._controller.redirectToAuth();
            }
            res.locals.mode = 'challenge';

            const {
                body: {challenges_enabled: challengeInfo, default_challenge: challengeType}
            } = result;
            const availableChallenges = Object.keys(challengeInfo);

            state.challenge = {
                challengeType,
                hint: challengeInfo[challengeType].hint,
                fieldValue: '',
                errorText: '',
                errorCode: '',
                isSms2faChallenge: res.locals.isSms2faChallenge
            };

            if (challengeType === 'phone_confirmation' || challengeType === 'push_2fa') {
                const {phone_confirmation: {phone_id: phoneId = null} = {}} = challengeInfo;

                state.challenge.phoneId = phoneId;
            }

            if (availableChallenges.length > 1) {
                const updatedDefaultChallenge = availableChallenges.find((item) => item !== challengeType);

                state.challenge.alternative = {
                    challengeType: updatedDefaultChallenge,
                    hint: challengeInfo[updatedDefaultChallenge].hint
                };
            }

            if (!state.common.track_id) {
                state.common.track_id = trackId;
            }

            return next();
        })
        .catch((error) => {
            if (Array.isArray(error)) {
                const errorCode = error[0];
                const isErrorToRedirect = (errorCode) => {
                    return [
                        'track_id.empty',
                        'track_id.invalid',
                        'track.not_found',
                        'unknowntrack',
                        'track.invalid_state',
                        'action.impossible',
                        'challenge.not_enabled',
                        'account.not_found',
                        'account.disabled',
                        'account.disabled_on_deletion',
                        'account.global_logout',
                        'sessionid.overflow',
                        'account.global_logout'
                    ].includes(errorCode);
                };

                if (isErrorToRedirect(errorCode)) {
                    return req._controller.redirectToLocalUrl({
                        pathname: 'auth'
                    });
                }

                if (errorCode === 'account.auth_passed') {
                    return req._controller.redirectToFrontpage();
                }

                if (errorCode === 'challenge.limit_exceeded') {
                    state.common.track_id = trackId;
                    state.challenge = {
                        errorCode: 'challenge.limit_exceeded'
                    };

                    return next();
                }
            }
        });
};
