const _ = require('lodash');
const url = require('url');
const config = require('../../configs/current');
const isDev = process.env.NODE_ENV === 'development';
const getMDAOptions = require('../common/getMDAOptions.js');
const apiRequest = require('./apiRequest.js');

const originsFromWebview = [
    'disk_app',
    'music_app',
    'telemost_app',
    'telemost_chat_app',
    'autofill',
    'zalogin_app',
    'bnpl_checkout'
];
const originsFromWebviewWithSocialAuth = ['music_app'];

module.exports = function createCommonState() {
    return [
        apiRequest('validateRetpath'),
        apiRequest('validateBackpath'),
        (req, res, next) => {
            const storeDraft = res.locals.store || (res.locals.store = {});
            const resultStore = storeDraft.common || (storeDraft.common = {});
            const yu = res._yandexuid && res._yandexuid.replace(/[^0-9]/g, '');
            const currentUrl = url.format(req._controller.getUrl());
            const {experiments, csrf} = res.locals;
            const apiRequestsResult = res.locals.result || {};
            const tld = req._controller.getTld();
            const currentUrlObj = url.parse(url.format(req._controller.getUrl()), true);
            const needMDA = req.cookies.mda === '1';
            const queryToPass = _.pick(req.query, ['clean', 'fretpath', 'from', 'origin']);
            const embeddedauthPath = config.paths.embeddedauth.replace('%tld%', needMDA ? 'ru' : tld);
            const embeddedAuthUrlObj = url.parse(embeddedauthPath, true);
            const noreturn = req.query.noreturn === '1';
            const isWebView = originsFromWebview.includes(queryToPass.origin) || queryToPass.from === 'social_auth';

            let retpath, backpath;

            if (apiRequestsResult.validateRetpath && apiRequestsResult.validateRetpath.retpath) {
                backpath = retpath = apiRequestsResult.validateRetpath.retpath;
                const mdaOptions = getMDAOptions(retpath);

                if (mdaOptions.needMDA) {
                    retpath = mdaOptions.redirectUrl;
                }

                queryToPass.retpath = retpath;
            }

            const profileUrl = url.format(
                Object.assign({}, currentUrlObj, {
                    pathname: 'profile',
                    search: null,
                    query: queryToPass
                })
            );

            const welcomePageUrl = url.format(
                Object.assign({}, currentUrlObj, {
                    pathname: '/auth/welcomepage',
                    search: null,
                    query: queryToPass
                })
            );

            if (apiRequestsResult.validateBackpath && apiRequestsResult.validateBackpath.retpath) {
                backpath = apiRequestsResult.validateBackpath.retpath;
            }

            const processUUIDQuery = {};

            if (res.locals.process_uuid) {
                processUUIDQuery.process_uuid = res.locals.process_uuid;
            }

            // Костыль пока https://st.yandex-team.ru/PASSP-34091 не выкатится в прод
            if (req.query.origin === 'zalogin_app') {
                const _backpath = typeof req.query.backpath === 'string' ? decodeURIComponent(req.query.backpath) : '';
                const _retpath = typeof req.query.retpath === 'string' ? decodeURIComponent(req.query.retpath) : '';

                if (_backpath.startsWith('ya-search-app-open://')) {
                    backpath = _backpath;
                }
                if (_retpath.startsWith('ya-search-app-open://')) {
                    retpath = _retpath;
                }
            }

            Object.assign(
                resultStore,
                {
                    backpath,
                    csrf,
                    currentUrl,
                    experiments,
                    retpath,
                    track_id: null,
                    magic_csrf_token: null,
                    noreturn,
                    yu,
                    clean: queryToPass.clean,
                    fretpath: queryToPass.fretpath,
                    origin: queryToPass.origin,
                    from: queryToPass.from,
                    captchaScaleFactor: 3,
                    isWebView,
                    isWebViewWithSocialAuth: originsFromWebviewWithSocialAuth.includes(queryToPass.origin),
                    dev: isDev,
                    neoPhonishPrefix: config.neoPhonishPrefix
                },
                {
                    backPane: null,
                    loginStatusRetpath: `https://${req.hostname}/auth/login-status_v2.html`,
                    embeddedauth_url: url.format(embeddedAuthUrlObj),
                    embeddedAuthUrlObjs: embeddedAuthUrlObj,
                    currentUrl: url.format(currentUrlObj),
                    addUserUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/add'
                            })
                        )
                    ).path,
                    addUserFullUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/add'
                            })
                        )
                    ).href,
                    preRegCompleteUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/precomplete'
                            })
                        )
                    ).path,
                    regCompleteUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/complete'
                            })
                        )
                    ).path,
                    welcomeUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/welcome'
                            })
                        )
                    ).path,
                    askAvatarUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/avatar'
                            })
                        )
                    ).path,
                    askPhoneUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/phone'
                            })
                        )
                    ).path,
                    phoneConfirmationUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/phone/confirm'
                            })
                        )
                    ).path,
                    phoneConfirmUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/phoneconfirm'
                            })
                        )
                    ).path,
                    askSocialUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/social'
                            })
                        )
                    ).path,
                    askEmailUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/email'
                            })
                        )
                    ).path,
                    editUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/list',
                                query: Object.assign({}, currentUrlObj.query, {
                                    mode: 'edit'
                                })
                            })
                        )
                    ).path,
                    addUserWithLoginUrl: url.format(
                        Object.assign({}, currentUrlObj, {
                            pathname: '/auth/add',
                            search: null,
                            query: Object.assign(
                                {},
                                queryToPass,
                                {
                                    login: 'login'
                                },
                                processUUIDQuery
                            )
                        })
                    ),
                    challengeUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/challenge',
                                query: Object.assign({}, queryToPass, {
                                    track_id: res.locals.track_id
                                })
                            })
                        )
                    ).path,
                    restoreLoginUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/restore/login',
                                query: Object.assign({}, currentUrlObj.query)
                            })
                        )
                    ).path,
                    restoreLoginProcessUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/restore/login/process',
                                query: Object.assign({}, currentUrlObj.query)
                            })
                        )
                    ).path,
                    restoreLoginResultUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/restore/login/result',
                                query: Object.assign({}, currentUrlObj.query)
                            })
                        )
                    ).path,
                    magicUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/magic'
                            })
                        )
                    ).path,
                    socialSuggest: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/social-suggest'
                            })
                        )
                    ).path,
                    restorePasswordUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/restore/password',
                                query: Object.assign({}, currentUrlObj.query)
                            })
                        )
                    ).path,
                    restorePasswordCaptchaUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/restore/password/captcha',
                                query: Object.assign({}, currentUrlObj.query)
                            })
                        )
                    ).path,
                    authLiteRegisterUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/register/lite'
                            })
                        )
                    ).path,
                    authLitePasswordUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/register/lite/form'
                            })
                        )
                    ).path,
                    authLiteNameUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/register/lite/name'
                            })
                        )
                    ).path,
                    authLiteEulaUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/register/lite/eula'
                            })
                        )
                    ).path,
                    authUrl: url.format(
                        Object.assign({}, currentUrlObj, {
                            query: queryToPass,
                            search: null,
                            pathname: '/auth'
                        })
                    ),
                    changePasswordUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/changepassword',
                                query: Object.assign({}, currentUrlObj.query)
                            })
                        )
                    ).path,
                    changeDefaultUrlObj: Object.assign({}, embeddedAuthUrlObj, {
                        search: null,
                        query: {
                            action: 'change_default',
                            yu
                        }
                    }),
                    multilogoutUrlObj: Object.assign({}, embeddedAuthUrlObj, {
                        search: null,
                        query: {
                            action: 'logout',
                            yu
                        }
                    }),
                    profile_url: profileUrl,
                    yandex_url: `https://yandex.${tld}`,
                    yandex_support_url:
                        (['ru', 'by', 'ua', 'kz', 'uz'].includes(tld) &&
                            'https://yandex.ru/support/search/troubleshooting/wish.html') ||
                        'https://yandex.com/support/search/troubleshooting/form.html',
                    restoration_url: url.format(
                        Object.assign({}, currentUrlObj, {
                            pathname: 'restoration',
                            search: null,
                            query: Object.assign({}, queryToPass, {login: 'login'}, processUUIDQuery)
                        })
                    ),
                    restoration_login_url: url.format(
                        Object.assign({}, currentUrlObj, {
                            pathname: 'restoration/login',
                            search: null,
                            query: Object.assign({}, queryToPass, processUUIDQuery)
                        })
                    ),
                    registration_url: url.format(
                        Object.assign({}, currentUrlObj, {
                            pathname: isWebView ? 'auth/reg' : 'registration',
                            search: null,
                            query: Object.assign({}, queryToPass, processUUIDQuery)
                        })
                    ),
                    lite_registration_url: url.format(
                        Object.assign({}, currentUrlObj, {
                            pathname: 'registration/lite',
                            search: null,
                            query: Object.assign({}, queryToPass, processUUIDQuery)
                        })
                    ),
                    registration_url_with_params: url.format(
                        Object.assign({}, currentUrlObj, {
                            pathname: isWebView ? 'auth/reg' : 'registration',
                            search: null,
                            query: Object.assign(
                                {},
                                queryToPass,
                                {
                                    login: 'login',
                                    phone_number: 'phone_number',
                                    country: 'country',
                                    skipLite: 1
                                },
                                processUUIDQuery
                            )
                        })
                    ),
                    lite_registration_url_with_params: url.format(
                        Object.assign({}, currentUrlObj, {
                            pathname: 'registration/lite',
                            search: null,
                            query: Object.assign(
                                {},
                                queryToPass,
                                {
                                    login: 'login',
                                    phone_number: 'phone_number',
                                    country: 'country'
                                },
                                processUUIDQuery
                            )
                        })
                    ),
                    liteRegisterUrl: url.format(
                        Object.assign({}, currentUrlObj, {
                            search: null,
                            pathname: '/auth/register/lite',
                            query: Object.assign(
                                {},
                                queryToPass,
                                {
                                    login: 'login',
                                    phone_number: 'phone_number',
                                    country: 'country'
                                },
                                processUUIDQuery
                            )
                        })
                    ),
                    preRegisterUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/preregister'
                            })
                        )
                    ).path,
                    profileSecurityWithCustoms: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/profile/security',
                                query: Object.assign({}, currentUrlObj.query, {
                                    forced: '1'
                                })
                            })
                        )
                    ).path,
                    profilePhonesUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/profile/phones'
                            })
                        )
                    ).path,
                    familyChildishRegOriginUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/profile/family',
                                query: Object.assign({}, currentUrlObj.query, {
                                    origin: 'childish_reg'
                                })
                            })
                        )
                    ).path,
                    welcomePageUrl
                }
            );

            return next();
        }
    ];
};
