const _ = require('lodash');

module.exports = function createMailAuthState(req, res, next) {
    const storeDraft = res.locals.store || (res.locals.store = {});
    const resultStore = storeDraft.mailAuth || (storeDraft.mailAuth = {});
    const experiments = res.locals.experiments;
    const experimentsIntersection = _.intersection(experiments.flags, [
        'magic_link_exp',
        'magic_link_exp_t1',
        'magic_link_exp_t2',
        'magic_link_exp_t3',
        'magic_link_exp_t4'
    ]);

    resultStore.isEnabled = Boolean(experimentsIntersection.length);

    if (resultStore.isEnabled) {
        resultStore.mailAuthExperiment = experimentsIntersection[0];
    }

    resultStore.isUpdatedAuthLetterStatus = false;

    next();
};
