module.exports = (req, res, next) => {
    const controller = req._controller;
    const {pathname} = controller.getUrl();
    const {store = {}} = res.locals;
    const {am = {}} = store;
    const {isAm, mode, appId, enableKey2fa} = am;
    const isAmPhoneconfirm = isAm && mode === 'phoneconfirm';
    const trackParams = {};

    if (appId) {
        trackParams.app_id = appId;
    }

    if (
        pathname.includes('/phoneconfirm') ||
        isAmPhoneconfirm ||
        (isAm && mode === 'phoneconfirm' && enableKey2fa && store.customs.isKeyEnabled2FA)
    ) {
        return Promise.all([req.api.getTrack(trackParams), req.api.yasmsGetState({filter: false})])
            .then((data = []) => {
                const {store = {}} = res.locals;
                const {am = {}} = res.locals;
                const [trackData, yasmsData] = data;
                const {body = {}} = trackData;
                const {id} = body;
                const {account = {}} = yasmsData;
                const {phones} = account;

                if (id) {
                    if (!store.common) {
                        store.common = {};
                    }

                    store.common.track_id = id;
                    req.api.track(id);
                }

                if (phones) {
                    const securePhoneId = Object.keys(phones).filter((id) => phones[id].secured);
                    const securePhone = securePhoneId && phones[securePhoneId];

                    if (!store.phoneConfirm) {
                        store.phoneConfirm = {
                            phoneNumber: (am.isAm && am.phone) || '',
                            securePhoneNumber: '',
                            errors: [],
                            confirmationCode: '',
                            isConfirmationCodeSent: false,
                            isCaptchaRequired: false,
                            isConfirmProcess: false
                        };
                    }

                    store.phoneConfirm.securePhoneNumber = securePhone && securePhone.number.international;
                    store.phoneConfirm.isSecurePhoneMode = !isAmPhoneconfirm && !pathname.startsWith('/auth');
                }

                return next();
            })
            .catch(next);
    }

    return next();
};
