const apiSetup = require('../common/apiSetup');
const createState = require('./createState');
const createAuthState = require('./createAuthState');

module.exports.route = [
    apiSetup,
    createState,
    createAuthState(),
    (req, res, next) => {
        req._controller
            .getCsrfToken()
            .then((token) => {
                res.locals.updatedCSRF = token;
                return next();
            })
            .catch(() => next());
    },
    (req, res) => {
        const store = res.locals.store || {};
        const authState = store.auth || {};

        return res.json({
            accounts: authState,
            csrf: res.locals.updatedCSRF
        });
    }
];
