const apiSetup = require('../common/apiSetup');
const validateCSRF = require('../common/validateCSRF');

module.exports = [
    apiSetup,
    validateCSRF,
    (req, res) => {
        req.api
            .authWithLetterInvalidate(req.body)
            .then((result) => res.json(result.body || result))
            .catch((errors) =>
                res.json({
                    status: 'error',
                    errors: errors || []
                })
            );
    }
];
