module.exports.maybeModifyStore = (req, res, next) => {
    const store = res.locals.store;

    if (store.common.experiments.flags.includes('auth-book-qr-exp')) {
        const authStore = store.auth;
        const {isWhiteLabel} = store.customs || {};
        const origin = req.query.origin || req.body.origin;
        const uaTraits = res.locals.ua;
        const isMobile = (uaTraits.isMobile || uaTraits.isTouch) && !uaTraits.isTablet;

        authStore.isBookQREnabled = !isMobile && !isWhiteLabel && !origin;
    }

    next();
};
