module.exports = function multiAuth(action, isMiddleware = false) {
    const availableActions = ['authLogout', 'authChangeDefault'];

    const apiHandle = action && availableActions.indexOf(action) !== -1;

    if (!apiHandle) {
        return (req, res, next) => next();
    }

    return (req, res, next) => {
        const controller = req._controller;
        const uid = req.body.uid || req.query.uid;
        const retpath = req.body.retpath || req.query.retpath;
        const yu = req.body.yu || req.query.yu;

        let trackId;

        const onError = (errors) =>
            res.json({
                status: 'error',
                errors: errors || []
            });

        const doSubmit = () => {
            req.api.writeTrack({retpath}).then((result) => {
                trackId = result.body.id;

                const params = {
                    track_id: trackId,
                    uid
                };

                req.api[action](params).then(({body}) => {
                    controller.augmentResponse(body);

                    if (isMiddleware) {
                        return next();
                    }

                    return res.json({status: 'ok'});
                }, onError);
            }, onError);
        };

        if (!yu) {
            return onError(['yu.empty']);
        }

        if (yu !== req.cookies.yandexuid) {
            return onError(['yu.invalid']);
        }

        if (!uid) {
            return onError(['uid.empty']);
        }

        return req.api.getTrack({type: 'authorize'}).then((result) => {
            trackId = result.body.id;

            return doSubmit();
        }, onError);
    };
};
