const url = require('url');
const apiSetup = require('../common/apiSetup');
const validateCSRF = require('../common/validateCSRF');

module.exports = [
    apiSetup,
    validateCSRF,
    (req, res, next) => {
        const {track_id, password} = req.body;

        req.api
            .authPasswordMultiStepCommitPassword({track_id, password})
            .then((result = {}) => {
                const {body} = result;
                const {track_id, state, account = {}} = body;

                if (state) {
                    const currentUrlObj = url.parse(url.format(req._controller.getUrl()), true);
                    const {display_name: {default_avatar = null} = {}} = account;

                    return res.json({
                        status: 'ok',
                        state,
                        avatarId: default_avatar,
                        redirect_url: url.parse(
                            url.format(
                                Object.assign({}, currentUrlObj, {
                                    search: null,
                                    pathname: '/auth',
                                    query: {
                                        track_id,
                                        one: 'yes'
                                    }
                                })
                            )
                        ).path
                    });
                }

                return next();
            })
            .catch((errors) =>
                res.json({
                    status: 'error',
                    errors: errors || []
                })
            );
    },
    (req, res) => {
        const {track_id, retpath} = req.body;

        req.api
            .bundleSession({track_id, retpath})
            .then(({body}) => {
                const {retpath, status, errors = []} = body;

                if (status !== 'ok') {
                    return res.json({
                        status,
                        errors
                    });
                }

                req._controller.augmentResponse(body);

                return res.json({status, retpath});
            })
            .catch((errors) =>
                res.json({
                    status: 'error',
                    errors: errors || []
                })
            );
    }
];
