const apiSetup = require('../common/apiSetup');
const passportApiSetup = require('../common/passportApiSetup');
const langSetup = require('../common/langSetup');
const validateCSRF = require('../common/validateCSRF');
const getYaExperimentsFlags = require('../common/getYaExperimentsFlags');
const PLog = require('plog');

module.exports = [
    langSetup,
    passportApiSetup,
    apiSetup,
    validateCSRF,
    getYaExperimentsFlags,
    (req, res, next) => {
        if (req.body.isCodeWithFormat) {
            req.body.code_format = 'by_3_dash';
        }

        return next();
    },
    (req, res, next) => {
        req.api
            .suggestCountry()
            .then(({body}) => {
                req.body.country = body && Array.isArray(body.country) && body.country[0];

                return next();
            })
            .catch(() => next());
    },
    (req, res) => {
        const {number, country, display_language: displayLanguage, track_id: trackId, code_format} = req.body;

        req._passportApi
            .phoneConfirmAndBindSecureSubmit({
                number,
                country,
                trackId,
                displayLanguage,
                code_format
            })
            .then((result = {}) =>
                res.json({
                    status: 'ok',
                    number: result.number,
                    deny_resend_until: result.deny_resend_until,
                    isPasswordRequired: result.is_password_required
                })
            )
            .catch((errors) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('auth.new.phoneConfirmAndBindSecureSubmit')
                    .write(errors);

                return res.json(errors._response);
            });
    }
];
