const passportApiSetup = require('../common/passportApiSetup');
const langSetup = require('../common/langSetup');
const validateCSRF = require('../common/validateCSRF');
const PLog = require('plog');

module.exports = [
    langSetup,
    passportApiSetup,
    validateCSRF,
    (req, res) => {
        const {phone_id: phoneId, display_language: displayLanguage} = req.body;

        req._passportApi
            .phoneProlongValid(phoneId, displayLanguage)
            .then(() => res.json({status: 'ok'}))
            .catch((errors) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('auth.new.phoneProlongValid')
                    .write(errors);

                return res.json(errors._response);
            });
    }
];
