module.exports = function prepareStatData(req, res, next) {
    const locals = res.locals;
    const auth = locals.store.auth;
    const common = locals.store.common;

    res.locals.preparedStat = Object.assign({}, res.locals.preparedStat, {
        opened_state: locals.mode,
        track_id: common.track_id || null,
        process_uuid: auth.process_uuid,
        default_uid: auth.authorizedAccountsDefaultUid || null,
        auth_accounts: String(auth.authorizedAccounts.length),
        sugg_accounts: String(auth.suggestedAccounts.length)
    });

    return next();
};
