const checkAuth = require('../../common/checkAuth');
const getCountry = require('../../common/getCountry');
const {captchaGenerate} = require('../../common/captchaGenerate');

const setRegistrationPhoneOnly = require('../../registration/setRegistrationPhoneOnly');

const {createStore} = require('../../authRegComplete/createStore');
const {AUTH_REG_COMPLETE_LOG_TYPE} = require('../../authRegComplete/constants');
const {profileGetState} = require('../../authRegComplete/profileGetState');
const {doCompleteSubmit} = require('../../authRegComplete/doCompleteSubmit');
const {redirectToRetpathIfNothingToDo} = require('../../authRegComplete/redirectToRetpathIfNothingToDo');

function maybeRunForRegComplete(handler) {
    return (req, res, next) => {
        if (res.locals.mode === 'upgrade') {
            return handler(req, res, next);
        }
        return next();
    };
}

function regComplete() {
    return [
        checkAuth,
        getCountry,
        captchaGenerate(AUTH_REG_COMPLETE_LOG_TYPE),
        profileGetState,
        createStore,
        setRegistrationPhoneOnly,
        doCompleteSubmit,
        redirectToRetpathIfNothingToDo
    ].map((handler) => maybeRunForRegComplete(handler));
}

module.exports = {
    maybeRunForRegComplete,
    regComplete
};
