const apiSetup = require('../../common/apiSetup');
const validateCSRF = require('../../common/validateCSRF');
const getRegistrationTrack = require('../../registration/getRegistrationTrack');

module.exports = [
    apiSetup,
    validateCSRF,
    (req, res, next) => {
        delete req.body.track_id;

        next();
    },
    getRegistrationTrack,
    (req, res) => {
        if (res.locals.track_id) {
            res.json({
                status: 'ok',
                track_id: res.locals.track_id
            });
        } else {
            res.json({
                status: 'error',
                error: 'track_not_available'
            });
        }
    }
];
