const apiSetup = require('../../common/apiSetup');
const validateCSRF = require('../../common/validateCSRF');

module.exports = [
    apiSetup,
    validateCSRF,
    function(req, res) {
        const handlers = [req.api.validateFirstName(req.body), req.api.validateLastName(req.body)];

        Promise.all(handlers)
            .then((response = []) => {
                const isOk = response.every((item) => item && item.body && item.body.status === 'ok');

                if (isOk) {
                    return res.json({status: 'ok'});
                }

                return res.json({status: 'error'});
            })
            .catch((error) => {
                if (Array.isArray(error)) {
                    const errorField = error[0].split('.')[0];

                    return res.json({
                        status: 'error',
                        field: errorField,
                        error
                    });
                }

                return res.json({status: 'error'});
            });
    }
];
