const config = require('../../configs/current');

module.exports = function renderPage(req, res) {
    const locals = res.locals;
    const lang = locals.language;
    const {pathname} = req._controller.getUrl() || {};
    const additionalDataRequest = locals.store.additionalDataRequest;

    let pane =
        [
            '/auth/verify',
            '/auth/child/restrict',
            '/auth/child/change',
            '/auth/child/exit',
            '/auth/child/add'
        ].find((path) => pathname.includes(path)) || '';

    if (res.locals.mode) {
        const mode = res.locals.mode;

        if (mode === 'edit') {
            pane = '/auth/list';
        } else if (mode === 'welcome') {
            pane = '/auth/welcome';
        } else if (mode === 'magic') {
            pane = '/auth/magic';
        } else if (mode === 'addingAccount') {
            pane = '/auth';
        } else if (mode === 'register') {
            pane = '/auth/reg';
        } else if (mode === 'upgrade') {
            pane = '/auth/complete';
        }
    }

    if (/^\/auth\/link\/?$/.test(pathname)) {
        pane = '/auth/link';
    }

    if (/^\/auth\/preregister\/?$/.test(pathname)) {
        pane = '/auth/preregister';
    }

    if (/^\/register\/link\/?$/.test(pathname)) {
        pane = '/register/link';
    }

    if (additionalDataRequest) {
        if (req.query.state) {
            additionalDataRequest.state = req.query.state;
        }

        if (req.query.action) {
            additionalDataRequest.action = req.query.action;
        }

        if (additionalDataRequest.state) {
            pane = `/auth/${additionalDataRequest.state}`;
        }
    }

    if (/^\/auth\/restore\/login\/?/.test(pathname)) {
        pane = '/auth/restore/login';
    }

    if (/^\/auth\/restore\/neo\/?/.test(pathname)) {
        pane = '/auth/restore/neo';
    }

    if (/^\/auth\/reg\/?$/.test(pathname)) {
        pane = '/auth/reg';
    }

    if (/^\/auth\/complete\/?$/.test(pathname)) {
        pane = '/auth/complete';
    }

    if (pathname.includes('/register/lite')) {
        pane = '/auth/register/lite';
    }

    if (pathname.includes('challenge')) {
        pane = '/auth/challenge';
    }

    if (pathname.includes('/phoneconfirm')) {
        pane = pathname.startsWith('/auth') ? '/auth/phoneconfirm' : '/phoneconfirm';
    }

    if (/^\/auth\/restore\/?$/.test(pathname)) {
        pane = locals.pagePane ? locals.pagePane : '/auth/restore/password/finish';
    }

    if (pathname.includes('/restore/password')) {
        pane = '/auth/restore/password';

        if (pathname.includes('captcha')) {
            pane = pathname;
        }
    }

    if (locals.aMpane) {
        pane = locals.aMpane;
    }

    res.locals.store.common.pane = pane;
    res.locals.ysaId = config.ysaIdMap.auth;

    res.render(`react.authv2.${lang}.jsx`);
};
