const apiSetup = require('../../common/apiSetup');
const validateCSRF = require('../../common/validateCSRF');
const handleErrors = require('./handleErrors');

module.exports.route = [
    apiSetup,
    validateCSRF,
    (req, res) => {
        req.api
            .getRestoreLoginCode(req.body)
            .then((result) => res.json(result.body || result))
            .catch((errors) =>
                res.json({
                    status: 'error',
                    errors: handleErrors(errors)
                })
            );
    }
];
